varying vec2 p_maskTextureCoord;
varying vec2 p_colorTextureCoord;
varying vec2 p_textureCoord1;
varying vec2 p_textureCoord2;
varying vec2 p_textureCoord3;
varying vec4 p_color;

uniform color_texture;
uniform base_texture;
uniform mask_texture;
uniform vec2 distortion1;
uniform vec2 distortion2;
uniform vec2 distortion3;
uniform float distortionScale;
uniform float distortionBias;


void main()
{
    vec4 noise1 = texture2D(base_texture, p_textureCoord1);
    vec4 noise2 = texture2D(base_texture, p_textureCoord2);
    vec4 noise3 = texture2D(base_texture, p_textureCoord3);
    vec4 refAlpha = texture2D(mask_texture, p_maskTextureCoord);

    // normalize to (-1. +1) range
    noise1 = (noise1 - 0.5) * 2.0;
    noise2 = (noise2 - 0.5) * 2.0;
    noise3 = (noise3 - 0.5) * 2.0;

    // distort noise
    noise1.xy = noise1.xy * distortion1.xy;
    noise2.xy = noise2.xy * distortion2.xy;
    noise3.xy = noise3.xy * distortion3.xy;

    vec2 finalNoise = noise1.xy + noise2.xy + noise3.xy;

    vec2 realNoiseCoords = ((1.0 - refAlpha.x) * distortionScale + distortionBias) * finalNoise.xy;

    vec4 flameColor = texture2D(color_texture, realNoiseCoords + p_colorTextureCoord.xy);
    vec4 alphaColor = texture2D(mask_texture, realNoiseCoords + p_maskTextureCoord.xy);

    flameColor.a = alphaColor.a;
    flameColor *= p_color; 

    //gl_FragColor = flameColor *  refAlpha;
    gl_FragColor = flameColor * alphaColor * refAlpha;
}
